---
title: Redirect admin area requests to HTTPS · Cloudflare Rules docs
description: Create a redirect rule to redirect requests for the administration
  area of `store.example.com` to HTTPS, keeping the original path and query
  string.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-admin-https/
  md: https://developers.cloudflare.com/rules/url-forwarding/examples/redirect-admin-https/index.md
---

This example single redirect for zone `example.com` will redirect requests for the administration area of a specific subdomain (`store.example.com`) to HTTPS, keeping the original path and query string.

**When incoming requests match**

* **Wildcard pattern**
  * **Request URL**: `http://store.example.com/admin*`

**Then**

* **Target URL**: `https://store.example.com/admin${1}`
* **Status code:** *301*
* **Preserve query string:** Enabled

For example, the redirect rule would perform the following redirects:

| Request URL | Target URL | Status code |
| - | - | - |
| `http://store.example.com/admin/products/` | `https://store.example.com/admin/products/` | `301` |
| `https://store.example.com/admin/products/` | (unchanged) | n/a |
| `http://store.example.com/admin/?logged_out=true` | `https://store.example.com/admin/?logged_out=true` | `301` |
| `http://store.example.com/?all_items=true` | (unchanged) | n/a |
| `http://example.com/admin/` | (unchanged) | n/a |
