---
title: Two-factor authentication · Cloudflare Fundamentals docs
description: We recommend that all Cloudflare user account holders enable
  two-factor authentication (2FA) to keep your accounts secure.
lastUpdated: 2025-11-10T10:23:27.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/user-profiles/2fa/
  md: https://developers.cloudflare.com/fundamentals/user-profiles/2fa/index.md
---

We recommend that all Cloudflare user account holders enable two-factor authentication (2FA) to keep your accounts secure. 

2FA can only be enabled successfully on an account with a [verified email address](https://developers.cloudflare.com/fundamentals/user-profiles/verify-email-address/). If you do not verify your email address first, you may lock yourself out of your account.

Warning

Super Administrators can turn on **2FA Enforcement** to require all members to enable 2FA. If you are not a Super Administrator, you will be forced to turn on 2FA prior to accepting the invitation to join a Cloudflare account as a member.

To enable two-factor authentication for your Cloudflare login:

1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/login).
2. Under the **My Profile** dropdown, select **My Profile**.
3. Select **Authentication**. 
4. Select **Manage** in the Two-Factor Authentication card.
5. Configure either a [TOTP mobile app](https://developers.cloudflare.com/fundamentals/user-profiles/2fa/#configure-totp-mobile-application-authentication) or a [security key to enable 2FA on your account](https://developers.cloudflare.com/fundamentals/user-profiles/2fa/#configure-security-key-authentication-for-two-factor-cloudflare-login).

## Configure security key authentication for two-factor Cloudflare login

Warning

Security keys only work with browsers that support the WebAuthn protocol.

A security key provides phishing-resistant multifactor authentication to your Cloudflare account using a built-in authenticator (Apple Touch ID, Android fingerprint, or Windows Hello) or an external hardware key (like [YubiKey](https://www.yubico.com/works-with-yubikey/catalog/cloudflare/)) that connects to your computer through USB-A, USB-C, NFC, or Bluetooth.

Cloudflare recommends configuring multiple security keys. With multiple keys, you can still use 2FA if the primary key is unavailable or if you are working on a different device.

After [enabling 2FA on your Cloudflare account](https://developers.cloudflare.com/fundamentals/user-profiles/2fa/#enable-two-factor-authentication-for-your-cloudflare-account), you can select **Manage** to configure 2FA security key authentication.

### Built-in authenticators

You can configure a built-in authenticator such as Apple Touch ID, Android fingerprint, or Windows Hello.

1. In **Security Key Authentication**, select **Add**.
2. On the **Add a Security Key**, enter your Cloudflare password and select **Next**.
3. Interact with your built-in authenticator to add it to your Cloudflare account.
4. Enter a name for the built-in authenticator. If this is the initial setup, you will be prompted to generate backup codes. If not, skip to Step 8.
5. Enter your Cloudflare password.
6. Select **Next** to review your backup codes. Backup codes can be used to access your user account without your mobile device.
7. Select **Download**, **Print**, or **Copy** to save your backup codes in a secure location.
8. Select **Next** to finish the configuration.

### Security keys

You can configure a security key, such as a Yubikey, to use with your account. Before you begin, ensure your hardware security key is configured and plugged in.

On a Windows device, you may need to set up Windows Hello or register your security key to your Microsoft account. Review the Windows documentation for more details.

1. Once your security key is plugged in, go to **Profile** > **Authentication**.
2. From **Two-Factor Authentication**, select **Set up**.
3. From **Security Key Authentication**, select **Add**.
4. Enter your Cloudflare password on the **Add a Security Key** screen, then select **Next**.
5. Interact with your security key to add it to your Cloudflare account. Ensure that the dialog is for the security key setup. If the Windows Hello dialog appears on a Windows device, select **Cancel**. The security key dialog box will then appear. Depending on your system, you may be required to register a PIN for the security key.
6. Enter a name for the security key. If this is the initial setup, you will be prompted to generate backup codes. If not, skip to Step 8.
7. Enter your Cloudflare password.
8. Select **Next** to review your backup codes. Backup codes can be used to access your user account without your mobile device.
9. Select **Download**, **Print**, or **Copy** to save your backup codes in a secure location.
10. Select **Next** to finish the configuration.

## Configure TOTP mobile application authentication

Time-based one-time password (TOTP) authentication works by using an authenticatior app, such as Google Authenticator or Microsoft Authenticator, which generates a secret code shared between the app and a website. When you log in to the website, you enter your username, password, and the secret code generated from the authenticator app. The secret code is only valid for a short period of time, about 30 to 60 seconds, before a new code is generated.

1. Once your security key is plugged in, go to **Profile** > **Authentication**.
2. From **Two-Factor Authentication**, select **Set up**.
3. Under **Mobile App Authentication**, select **Add**.
4. Scan the QR code with your mobile device and enter the code from your authenticator application.
5. Enter your Cloudflare password, then select **Next**. If you cannot scan the QR code, select **Can't scan QR code, Follow alternative steps** to configure your authenticator application manually.

![You can enable 2FA by scanning a QR code with your mobile device.](https://developers.cloudflare.com/_astro/2FA_scan_QR_code.t5BNYUYn_2jomLN.webp)

1. Enter your Cloudflare password again.
2. Select **Next** to review your backup codes. You can use backup codes to access your account without your mobile device.
3. Select **Download**, **Print**, or **Copy** to save your backup codes in a secure location.

Note

To avoid being locked out of your account, be sure to generate and save your recovery codes. If you forget your password and cannot receive the reset code or lose access to your phone with the authenticator app, you can use the recovery codes to access your account.

You can regenerate your backup codes at any time using the Cloudflare dashboard.

1. Select **Next** on the backup code page to complete the recovery code setup.

### Reconfigure TOTP mobile application authentication

You may need to reconfigure your mobile application authentication if you join a new organization or lose access to your mobile device. When you reconfigure your mobile application authentication, your previous TOTP codes are invalid.

Note

Reconfiguring TOTP mobile application authentication does not turn off 2FA.

To reconfigure, follow [Steps 1-7](https://developers.cloudflare.com/fundamentals/user-profiles/2fa/#configure-totp-mobile-application-authentication) as detailed above.

## Regenerate backup codes

Each backup code is one-time use only, but you can always request a new set of backup codes using the Cloudflare dashboard. This is useful if you have lost access to or used all of your previous backup codes.

Note

Regenerating your backup codes will invalidate your previous codes.

1. Log in to the Cloudflare dashboard.

   [Go to **Account home**](https://dash.cloudflare.com/?to=/:account/home)

2. Select **My Profile**.

3. Select **Authentication**.

4. For **Two-Factor Authentication**, select **Manage**.

5. For **Backup codes**, select **Regenerate** to generate and save a new set of two-factor backup codes.

## Disable two-factor authentication for your Cloudflare account

To disable 2FA for your Cloudflare account, you must delete all security keys and TOTP authenticators from your account.

Note

If you are not the Super Administrator of an organization with **2FA Enforcement** enabled, you may not have permission to disable 2FA.

1. Log in to the Cloudflare dashboard.

   [Go to **Account home**](https://dash.cloudflare.com/?to=/:account/home)

2. Select **Profile**.

3. Select the **Authentication**.

   * To remove your security key:

     1. Select **Edit** in the **Security Key Authentication** card. A drop-down menu shows more details about your security key.
     2. Select **Delete**.
     3. Enter your Cloudflare password, then select **Remove**.

   * To remove your TOTP mobile application authentication:

     1. Select **Delete method** in the **Mobile App Authentication** card.
     2. Enter your Cloudflare password, authenticator application code, or a recovery code, then select **Disable**.

![how to disable your TOTP mobile application authentication.](https://developerdocsgifs.cloudflaretraining.com/resampled_5fps_disable_mobile_auth_v2_final.gif)

## Use a backup code

If you lose access to a mobile device, security key, or authentication code, you can solve these issues by using a backup code or retrieving a backup code from your preferred authentication app.

Refer to Google's documentation to [transfer Google Authenticator codes from one Android device to another](https://support.google.com/accounts/answer/1066447?co=GENIE.Platform%3DAndroid\&hl=en\&oco=0).

When setting up 2FA, you should have saved your backup codes in a secure location. To restore lost access using a Cloudflare backup code:

1. Retrieve the backup code from where you stored it.

2. Go to the [Cloudflare login page](https://dash.cloudflare.com/login), enter your username and password and select **Log in**.

   [Go to **Account home**](https://dash.cloudflare.com/?to=/:account/home)

3. You should see a page titled **Two-Factor Authentication**

   * If it has a text box, enter one of your backup codes and select **Log in**.
   * If instead you see "Insert your security key and touch it", cancel any prompts from your browser that appear and select **try another authentication method or backup code**. Proceed to enter one of your backup codes and select **Log in**.

Note

Once you use a backup code, it becomes invalid.

## Recover your account

If you do not have access to your 2FA account or backup codes and cannot currently generate a 2FA code, use a verified device that you have logged in from before to request a temporary access code.

1. Log into the [Cloudflare dashboard](https://dash.cloudflare.com/login).

   [Go to **Account home**](https://dash.cloudflare.com/?to=/:account/home)

2. On the **Two-Factor Authentication** page, select **Try recovery** on **Lost all 2FA devices and backup codes?**.

3. Select **Begin recovery**.

4. A 6-digit access code will be sent to the email address associated with your Cloudflare account.

5. Enter the temporary access code into the Cloudflare Dashboard and select **Verify email**.

6. Select **Verify device**. This checks whether you are using a device that has previously logged into your account.

If you see **Device verified**, you will receive an email within 3-5 days with instructions to regain access to your account. It is important to note this process cannot be expedited, so you will need to wait until that email arrives before you can proceed.

If you see **Device verification failed**, you may be able to try again considering the following:

* If you clear your cookies often or are logging in from a different IP address, you have wiped Cloudflare's memory of your device and will need to use a different device to verify.
* Your browser may be set to clear cookies on exit or after browser or OS upgrades. This interferes with the device verification process.
* You may be using anti-malware or other software that automatically clears your browser cookies and makes your device unregognizable by Cloudflare's Dashboard.

If you are still unable to verify your device, follow the instructions to *Request manual verification* on the **Device verification failed** page.

***

## Related resources

* [Google Authentication documentation](https://support.google.com/accounts/answer/1066447?hl=en\&ref_topic=2954345\&co=GENIE.Platform%3DiOS\&oco=0)
* [YubiKey documentation](https://www.yubico.com/works-with-yubikey/catalog/cloudflare/)
* [Set up multi-user accounts on Cloudflare](https://developers.cloudflare.com/fundamentals/manage-members/)
